# 通知設計書 5-Internal Server Error通知

## 概要

本ドキュメントは、Horse Webフレームワークにおける Internal Server Error通知機能の設計を記述する。コールバック実行中の予期しない例外発生時にクライアントへHTTP 500エラーを返却する通知機能である。

### 本通知の処理概要

本通知は、HTTPリクエスト処理中にルートコールバック内で予期しない例外が発生した際に、クライアントに対してHTTP 500 Internal Server Errorレスポンスを返却する機能を提供する。

**業務上の目的・背景**：Web APIやWebアプリケーションにおいて、サーバー側で予期しないエラーが発生した場合、クライアントに適切なエラーレスポンスを返すことは基本要件である。この通知により、クライアントアプリケーションはサーバーエラーを検知でき、ユーザーへの適切なエラー表示やリトライ処理が可能となる。また、エラーレスポンスを統一することでAPIの一貫性が保たれる。

**通知の送信タイミング**：ルートコールバック（THorseCallback）実行中に例外が発生し、かつその例外がEHorseCallbackInterruptedでもEHorseExceptionでもなく、さらにレスポンスステータスがまだ400未満の場合に送信される。

**通知の受信者**：HTTPリクエストを送信したクライアント（Webブラウザ、モバイルアプリ、他のサービス等）。

**通知内容の概要**：レスポンスボディに「Internal Application Error」というメッセージが含まれ、HTTPステータスコード500が返却される。

**期待されるアクション**：クライアントはサーバーエラーを検知し、ユーザーにエラーメッセージを表示する、リトライを行う、または管理者に通知するなどの適切なエラーハンドリングを行う。

## 通知種別

HTTPレスポンス - HTTP 500 Internal Server Error

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（HTTPレスポンス） |
| 優先度 | 即時 |
| リトライ | 無し（クライアント側で判断） |

### 送信先決定ロジック

HTTPリクエストを送信したクライアントに対してレスポンスとして返却される。送信先は自動的にリクエスト元に決定される。

## 通知テンプレート

### HTTPレスポンスの場合

| 項目 | 内容 |
|-----|------|
| HTTPステータスコード | 500 |
| ステータスメッセージ | Internal Server Error |
| Content-Type | text/html (デフォルト) |
| 形式 | テキスト |

### 本文テンプレート

```
Internal Application Error
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | HTTPレスポンスボディのみ |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | - | 固定メッセージのため変数なし | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コールバック例外 | LCallback.Items[FIndexCallback]実行中の例外 | 下記3条件をすべて満たす場合 | ルートコールバック内での予期しない例外 |

**送信条件の詳細**:
1. 例外がEHorseCallbackInterrupted**ではない**
2. 例外がEHorseException**ではない**
3. FResponse.Statusが400未満（まだエラーステータスが設定されていない）

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| EHorseCallbackInterrupted | 意図的なコールバック中断例外の場合は送信されない |
| EHorseException | Horse独自例外の場合は送信されない（独自のエラーハンドリングが想定） |
| ステータス400以上 | 既にエラーステータスが設定されている場合は上書きしない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[HTTPリクエスト受信] --> B[ルーティング]
    B --> C[コールバック実行]
    C --> D{例外発生?}
    D -->|発生| E{EHorseCallbackInterrupted?}
    E -->|Yes| F[例外を再throw]
    E -->|No| G{EHorseException?}
    G -->|Yes| F
    G -->|No| H{FResponse.Status < 400?}
    H -->|Yes| I[500エラーレスポンス送信]
    I --> J[Internal Application Error]
    J --> F
    H -->|No| F
    D -->|なし| K[正常レスポンス]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | 本通知はデータベースを使用しない |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本通知はデータベースを更新しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 任意の例外 | コールバック内で未処理例外が発生 | 500エラーを返却後、例外を再throwする |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | サーバー側では行わない（クライアント側で判断） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

HTTPリクエスト処理中に即座に送信される。時間帯の制限はない。

## セキュリティ考慮事項

- 例外の詳細情報（スタックトレース、内部エラーメッセージ等）はクライアントに公開されない
- 固定メッセージ「Internal Application Error」のみが返却されるため、情報漏洩リスクは低い
- 例外は500エラー返却後も再throwされるため、サーバー側でのログ記録やデバッグが可能

## 備考

- 例外発生後も`raise`により例外は再throwされるため、上位のエラーハンドラでキャッチ可能
- EHorseExceptionは独自のステータスコードとメッセージを持つため、この通知の対象外
- THTTPStatus.InternalServerErrorはHorse.Commons.pasで定義されている（値: 500）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

HTTPステータスコードと例外クラスの関係を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Commons.pas | `src/Horse.Commons.pas` | THTTPStatus列挙型（行24-87）、特にInternalServerError = 500 |
| 1-2 | Horse.Exception.pas | `src/Horse.Exception.pas` | EHorseExceptionクラス定義 |
| 1-3 | Horse.Exception.Interrupted.pas | `src/Horse.Exception.Interrupted.pas` | EHorseCallbackInterrupted定義 |

**読解のコツ**: Horse独自の例外クラスは通常の例外とは異なる扱いを受ける。EHorseExceptionは独自のステータスを持ち、EHorseCallbackInterruptedは意図的な中断を示す。

#### Step 2: エントリーポイントを理解する

コールバック実行と例外処理の流れを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Core.RouterTree.NextCaller.pas | `src/Horse.Core.RouterTree.NextCaller.pas` | Nextメソッド（行80-131）がコールバック実行の中心 |

**主要処理フロー**:
1. **行94-95**: FCallBack.TryGetValue でコールバックリスト取得
2. **行97-114**: コールバック実行ループ
3. **行99-112**: try-except でコールバック実行を囲む
4. **行101**: `LCallback.Items[FIndexCallback](FRequest, FResponse, Next)` - **コールバック実行**
5. **行102-111**: except句での例外処理
6. **行105-107**: 3条件のチェック
7. **行108-109**: `FResponse.Send('Internal Application Error').Status(THTTPStatus.InternalServerError)` - **ここが500エラー通知の送信箇所**
8. **行110**: `raise` - 例外の再throw

#### Step 3: 例外判定ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Core.RouterTree.NextCaller.pas | `src/Horse.Core.RouterTree.NextCaller.pas` | 行105-107の条件式を確認 |

**条件式の詳細**:
```pascal
if (not(E is EHorseCallbackInterrupted)) and
   (not(E is EHorseException)) and
   (FResponse.Status < Integer(THTTPStatus.BadRequest))
then
```
- `E is EHorseCallbackInterrupted` - 意図的中断でないか
- `E is EHorseException` - Horse独自例外でないか
- `FResponse.Status < Integer(THTTPStatus.BadRequest)` - ステータス < 400 か（BadRequest = 400）

### プログラム呼び出し階層図

```
THorseRouterTree.Execute (行139)
    │
    └─ THorseRouterTree.ExecuteInternal (行168)
           │
           └─ TNextCaller.Next (行80)
                  │
                  ├─ ミドルウェア実行 (行84-91)
                  │
                  └─ コールバック実行 (行92-126)
                         │
                         ├─ try (行99)
                         │      │
                         │      └─ LCallback.Items[FIndexCallback](...) (行101)
                         │             │
                         │             └─ [ユーザー定義コールバック]
                         │                    │
                         │                    └─ 例外発生!
                         │
                         └─ except (行102-111)
                                │
                                ├─ 条件チェック (行105-107)
                                │
                                ├─ FResponse.Send('Internal Application Error')
                                │      .Status(THTTPStatus.InternalServerError)
                                │      (行108-109)
                                │
                                └─ raise (行110)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

HTTPリクエスト     ───▶ ルーティング                   ───▶ HTTPレスポンス
                           │                                  Status: 500
                           ▼                                  Body: "Internal
                    コールバック実行                           Application Error"
                           │
                           ▼
                    例外発生（任意の例外）
                           │
                           ▼
                    条件チェック
                    - not EHorseCallbackInterrupted
                    - not EHorseException
                    - Status < 400
                           │
                           ▼
                    FResponse.Send('Internal Application Error')
                           │
                           ▼
                    .Status(THTTPStatus.InternalServerError)
                           │
                           ▼
                    raise (例外を再throw)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Core.RouterTree.NextCaller.pas | `src/Horse.Core.RouterTree.NextCaller.pas` | ソース | コールバック実行と例外処理、500エラー通知の送信元 |
| Horse.Commons.pas | `src/Horse.Commons.pas` | ソース | THTTPStatus列挙型、InternalServerError = 500 |
| Horse.Exception.pas | `src/Horse.Exception.pas` | ソース | EHorseException例外クラス |
| Horse.Exception.Interrupted.pas | `src/Horse.Exception.Interrupted.pas` | ソース | EHorseCallbackInterrupted例外クラス |
| Horse.Response.pas | `src/Horse.Response.pas` | ソース | THorseResponse.Send/Statusメソッド |
